/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.console;

import com.ibm.hsc.access.server.HmcCryptor;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class OmHostsInfo {
    public static final int OMHI_VERSION = 100;
    public static final int OMHI_SETPWD = 1;
    public static final String charSet = "UTF-8";
    protected static final int MBYTES_SIZE = 60;
    protected static final int BPCIP = 4;
    protected static final int BPCID = 8;
    protected static final int BPCID_LENGTH = 16;
    protected static final int BPCID_MAX = 20;
    protected static final int BPCPWD = 28;
    protected static final int BPCPWD_LENGTH = 31;
    protected static final int BPCPWD_MAX = 32;
    protected static final int HEADER_SIZE = 16;
    protected static final int BPCSN_START = 16;
    protected static final int BPCSN_END = 23;
    protected static final String OMHI_NULL = "$$No$Value$Set$$";
    protected static final String OMHI_DEFAULT_PWD = "YzcmilwL+Uw=";
    protected static final String OMHI_DBG = "/var/hsc/log/.debug_omhi";
    protected static final String OMHI_PUSHIP = "PushBpaIpTableToFSP";
    protected static final String CHK_DHCPSVR = "/etc/init.d/dhcpd status";
    protected static final String HMCCFG_FILE = "/opt/hsc/data/hmc.properties";
    protected static String BPC_HOSTS_FILE = "/opt/hsc/data/bpcHosts";
    protected static Hashtable s_bpcCache = new Hashtable();
    protected static Hashtable s_bpcList = new Hashtable();
    protected static int s_Enabled = 0;
    protected static Class thisClass;
    protected static long modifyTime;
    protected static HmcCryptor s_crypt;
    private byte[] m_bytes = new byte[60];
    private String m_bpcPwd = "$$No$Value$Set$$";
    private String m_bpcPwdBkup = "$$No$Value$Set$$";
    private String m_host = "$$No$Value$Set$$";

    public static boolean isDHCPsvrRunning() {
        int n = -1;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(CHK_DHCPSVR);
            process.waitFor();
            n = process.exitValue();
        }
        catch (Throwable throwable) {
            if (process != null) {
                process.destroy();
            }
            throwable.printStackTrace();
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static int loadBPCipList() {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n;
        int n2;
        FileInputStream fileInputStream = null;
        int n3 = 0;
        byte[] byArray4 = new byte[60];
        byte[] byArray5 = new byte[8];
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        if (!new File(BPC_HOSTS_FILE).exists()) {
            System.err.println("OMHI: No existing HostsInfo to be loaded.");
            return n3;
        }
        fileInputStream = new FileInputStream(BPC_HOSTS_FILE);
        fileInputStream.read(byArray5);
        int n4 = byArray5[0] << 8 & 0xFF00 | byArray5[1] & 0xFF;
        int n5 = byArray5[2] << 8 & 0xFF00 | byArray5[3] & 0xFF;
        int n6 = byArray5[4] << 8 & 0xFF00 | byArray5[5] & 0xFF;
        int n7 = byArray5[6] << 8 & 0xFF00 | byArray5[7] & 0xFF;
        for (n2 = 0; n2 < n6; ++n2) {
            fileInputStream.read(byArray4);
            n = fileInputStream.read();
            byArray3 = new byte[n];
            fileInputStream.read(byArray3);
            n = fileInputStream.read();
            byArray2 = new byte[n];
            fileInputStream.read(byArray2);
            n = fileInputStream.read();
            byArray = new byte[n];
            fileInputStream.read(byArray);
            OmHostsInfo.createBpcIpInfo(byArray4, byArray3, byArray2, byArray, false);
            ++n3;
        }
        for (n2 = 0; n2 < n7; ++n2) {
            fileInputStream.read(byArray4);
            n = fileInputStream.read();
            byArray3 = new byte[n];
            fileInputStream.read(byArray3);
            n = fileInputStream.read();
            byArray2 = new byte[n];
            fileInputStream.read(byArray2);
            n = fileInputStream.read();
            byArray = new byte[n];
            fileInputStream.read(byArray);
            OmHostsInfo.createBpcIpInfo(byArray4, byArray3, byArray2, byArray, true);
            ++n3;
        }
        System.err.println("OMHI: Finished loading the HostsInfo.");
        modifyTime = System.currentTimeMillis();
        int n8 = n3;
        Object var18_16 = null;
        modifyTime = System.currentTimeMillis();
        Locale.setDefault(locale);
        try {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            System.err.println("OmHostsInfo: (loadIpList) close file failed.");
            exception.printStackTrace();
        }
        return n8;
        catch (IOException iOException) {
            try {
                System.err.println("OmHostsInfo: (loadIpList) IO failed.");
                iOException.printStackTrace();
                Object var18_17 = null;
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                modifyTime = System.currentTimeMillis();
                Locale.setDefault(locale);
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    System.err.println("OmHostsInfo: (loadIpList) close file failed.");
                    exception.printStackTrace();
                }
                throw throwable;
            }
            modifyTime = System.currentTimeMillis();
            Locale.setDefault(locale);
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                System.err.println("OmHostsInfo: (loadIpList) close file failed.");
                exception.printStackTrace();
            }
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void saveBPCipList() throws PIHscServerException {
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[8];
        if (s_bpcList.size() <= 0 && s_bpcCache.size() <= 0) {
            return;
        }
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        try {
            try {
                OmHostsInfo omHostsInfo;
                fileOutputStream = new FileOutputStream(BPC_HOSTS_FILE);
                byArray[0] = 0;
                byArray[1] = 100;
                int n = s_crypt.getCurrentScheme();
                byArray[2] = (byte)(n >> 8 & 0xFF);
                byArray[3] = (byte)(n & 0xFF);
                int n2 = s_bpcCache.size();
                byArray[4] = (byte)(n2 >> 8 & 0xFF);
                byArray[5] = (byte)(n2 & 0xFF);
                n2 = s_bpcList.size();
                byArray[6] = (byte)(n2 >> 8 & 0xFF);
                byArray[7] = (byte)(n2 & 0xFF);
                fileOutputStream.write(byArray);
                Enumeration enumeration = s_bpcCache.elements();
                while (enumeration.hasMoreElements()) {
                    omHostsInfo = (OmHostsInfo)enumeration.nextElement();
                    fileOutputStream.write(omHostsInfo.m_bytes);
                    fileOutputStream.write((byte)omHostsInfo.m_bpcPwd.length());
                    fileOutputStream.write(omHostsInfo.m_bpcPwd.getBytes(charSet));
                    fileOutputStream.write((byte)omHostsInfo.m_bpcPwdBkup.length());
                    fileOutputStream.write(omHostsInfo.m_bpcPwdBkup.getBytes(charSet));
                    fileOutputStream.write((byte)omHostsInfo.m_host.length());
                    fileOutputStream.write(omHostsInfo.m_host.getBytes(charSet));
                }
                enumeration = s_bpcList.elements();
                while (enumeration.hasMoreElements()) {
                    omHostsInfo = (OmHostsInfo)enumeration.nextElement();
                    fileOutputStream.write(omHostsInfo.m_bytes);
                    fileOutputStream.write((byte)omHostsInfo.m_bpcPwd.length());
                    fileOutputStream.write(omHostsInfo.m_bpcPwd.getBytes(charSet));
                    fileOutputStream.write((byte)omHostsInfo.m_bpcPwdBkup.length());
                    fileOutputStream.write(omHostsInfo.m_bpcPwdBkup.getBytes(charSet));
                    fileOutputStream.write((byte)omHostsInfo.m_host.length());
                    fileOutputStream.write(omHostsInfo.m_host.getBytes(charSet));
                }
                Object var9_7 = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new PIHscServerException("3074");
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Locale.setDefault(locale);
            try {
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new PIHscServerException("3074");
            }
        }
        Locale.setDefault(locale);
        try {}
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new PIHscServerException("3074");
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    static String encryptPassword(String string) {
        return s_crypt.cryptString(string, true);
    }

    protected static String decryptPassword(String string) {
        return s_crypt.cryptString(string, false);
    }

    protected static void createBpcIpInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, boolean bl) {
        OmHostsInfo omHostsInfo = new OmHostsInfo(byArray, byArray2, byArray3, byArray4);
        if (bl) {
            s_bpcList.put(OmHostsInfo.buildBpcKey(byArray[0], omHostsInfo.getBpcID(0)), omHostsInfo);
        } else {
            s_bpcCache.put(omHostsInfo.getBpcHost(), omHostsInfo);
        }
    }

    protected static OmHostsInfo addHostInfoObj(String string, String string2) {
        OmHostsInfo omHostsInfo = (OmHostsInfo)s_bpcCache.get(string);
        if (omHostsInfo != null) {
            if (string2 != null) {
                omHostsInfo.setBpcPassword(string2);
            }
        } else {
            omHostsInfo = new OmHostsInfo(0, 0L, OMHI_NULL, string2, string);
            s_bpcCache.put(string, omHostsInfo);
        }
        return omHostsInfo;
    }

    protected static OmHostsInfo addHostInfoObj(byte by, long l, String string, String string2, String string3) {
        OmHostsInfo omHostsInfo = null;
        String string4 = OmHostsInfo.buildBpcKey(by, string);
        omHostsInfo = (OmHostsInfo)s_bpcList.get(string4);
        if (omHostsInfo != null) {
            omHostsInfo.setBpcIp(l);
            omHostsInfo.setBpcPassword(string2);
            if (string3 != null && string3.length() > 0) {
                omHostsInfo.m_host = string3;
            }
        } else {
            omHostsInfo = new OmHostsInfo(by, l, string, string2, string3);
            s_bpcList.put(string4, omHostsInfo);
        }
        return omHostsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OmHostsInfo getBpcHostsInfo(byte by, String string, boolean bl) {
        OmHostsInfo omHostsInfo = null;
        if (by >= 0) {
            omHostsInfo = (OmHostsInfo)s_bpcList.get(OmHostsInfo.buildBpcKey(by, string));
        } else if (by == -1) {
            Class clazz = thisClass;
            synchronized (clazz) {
                long l = OmHostsInfo.getLongValueOfIPstr(string);
                Enumeration enumeration = s_bpcList.keys();
                while (enumeration.hasMoreElements()) {
                    OmHostsInfo omHostsInfo2 = (OmHostsInfo)s_bpcList.get(enumeration.nextElement());
                    if (l != omHostsInfo2.getBpcIPlong()) continue;
                    omHostsInfo = omHostsInfo2;
                    break;
                }
            }
        } else if (by == -2) {
            omHostsInfo = (OmHostsInfo)s_bpcCache.get(string);
        }
        if (bl && omHostsInfo != null) {
            return new OmHostsInfo(omHostsInfo);
        }
        return omHostsInfo;
    }

    public static String buildBpcKey(byte by, String string) {
        return by + "*" + string;
    }

    public static boolean isEnabled() {
        return s_Enabled == 1;
    }

    public static int howManyHosts() {
        return s_bpcList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmHostsInfo createBpcIpInfo(byte by, long l, String string, String string2, String string3, boolean bl) throws PIHscServerException {
        OmHostsInfo omHostsInfo = null;
        if (bl) {
            if (by < 1 || by > 2 || l < 0L || string == null || string.length() != 16 || string2 != null && (string2.length() <= 0 || string2.length() > 31)) {
                System.err.println("OMHI create Err: num=" + by + " ip=" + l + " ID=" + string + " host=" + string3 + " inList=" + bl);
                throw new PIHscServerException("3075");
            }
            Class clazz = thisClass;
            synchronized (clazz) {
                byte by2;
                String string4;
                OmHostsInfo omHostsInfo2;
                omHostsInfo = OmHostsInfo.addHostInfoObj(by, l, string, string2, string3);
                if (omHostsInfo != null && string2 != null && (omHostsInfo2 = (OmHostsInfo)s_bpcList.get(string4 = OmHostsInfo.buildBpcKey(by2 = (byte)(by == 1 ? 2 : 1), string))) != null) {
                    omHostsInfo2.setBpcPassword(string2);
                }
                OmHostsInfo.saveBPCipList();
            }
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 31) || string3 == null || string3.length() <= 0) {
            System.err.println("OMHI create Err: host=" + string3);
            throw new PIHscServerException("3075");
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            omHostsInfo = OmHostsInfo.addHostInfoObj(string3, string2);
            OmHostsInfo.saveBPCipList();
        }
        return omHostsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmHostsInfo createBpcIpInfo(String string, String string2) throws PIHscServerException {
        OmHostsInfo omHostsInfo;
        if (string == null || string.length() <= 0 || string2 != null && (string2.length() <= 0 || string2.length() > 31)) {
            System.err.println("OMHI create Err: host=" + string);
            throw new PIHscServerException("3075");
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            omHostsInfo = OmHostsInfo.addHostInfoObj(string, string2);
            OmHostsInfo.saveBPCipList();
        }
        return omHostsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OmHostsInfo createBpcIpInfo(byte by, String string, String string2, String string3) throws PIHscServerException {
        OmHostsInfo omHostsInfo;
        long l;
        if (by < 1 || by > 2 || string == null || (l = OmHostsInfo.getLongValueOfIPstr(string)) <= 0L || string2 == null || string2.length() != 16 || string3 != null && (string3.length() <= 0 || string3.length() > 31)) {
            System.err.println("OMHI create Err: num=" + by + " ip=" + string + " ID=" + string2);
            throw new PIHscServerException("3075");
        }
        Class clazz = thisClass;
        synchronized (clazz) {
            String string4;
            OmHostsInfo omHostsInfo2;
            omHostsInfo = OmHostsInfo.addHostInfoObj(by, l, string2, string3, null);
            if (omHostsInfo != null && string3 != null && (omHostsInfo2 = (OmHostsInfo)s_bpcList.get(string4 = by == 1 ? OmHostsInfo.buildBpcKey((byte)2, string2) : OmHostsInfo.buildBpcKey((byte)1, string2))) != null) {
                omHostsInfo2.setBpcPassword(string3);
            }
            OmHostsInfo.saveBPCipList();
        }
        return omHostsInfo;
    }

    public static long getLongValueOfIPstr(String string) {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return l;
        }
        for (int i = 0; i < 4; ++i) {
            l = l * 256L + Long.parseLong(stringTokenizer.nextToken());
        }
        return l;
    }

    public static OmHostsInfo getBpcIpInfo(byte by, String string) throws PIHscServerException {
        return OmHostsInfo.getBpcHostsInfo(by, string, true);
    }

    public static void setPassword(byte by, String string, String string2, String string3) throws PIHscServerException {
        OmHostsInfo.setPassword(by, string, string2, string3, "0.0.0.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPassword(byte by, String string, String string2, String string3, String string4) throws PIHscServerException {
        boolean bl = false;
        boolean bl2 = false;
        long l = OmHostsInfo.getLongValueOfIPstr(string4);
        System.err.println("OMHI setPwd: num=" + by + " ip=" + string4 + " ID=" + string + " host=" + string2);
        if (by < 1 || by > 2 || l < 0L || string == null || string.length() != 16 || string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0 || string3.length() > 31) {
            throw new PIHscServerException("3075");
        }
        byte by2 = (byte)(by == 1 ? 2 : 1);
        Class clazz = thisClass;
        synchronized (clazz) {
            OmHostsInfo omHostsInfo;
            OmHostsInfo omHostsInfo2 = OmHostsInfo.getBpcHostsInfo(by, string, false);
            if (omHostsInfo2 != null) {
                bl = true;
                if (!omHostsInfo2.m_bpcPwd.equals(OmHostsInfo.encryptPassword(string3))) {
                    omHostsInfo2.setBpcPassword(string3);
                    bl2 = true;
                }
                if (l > 0L && omHostsInfo2.getBpcIPlong() != l) {
                    omHostsInfo2.setBpcIp(l);
                    bl2 = true;
                }
                if (string2 != null && !omHostsInfo2.m_host.equalsIgnoreCase(string2)) {
                    omHostsInfo2.m_host = string2;
                    bl2 = true;
                }
            } else {
                omHostsInfo2 = (OmHostsInfo)s_bpcCache.get(string2);
                if (omHostsInfo2 != null) {
                    s_bpcCache.remove(string2);
                    OmHostsInfo.addHostInfoObj(by, l, string, string3, string2);
                    bl = true;
                    bl2 = true;
                }
            }
            if (bl && (omHostsInfo = OmHostsInfo.getBpcHostsInfo(by2, string, false)) != null && !omHostsInfo.m_bpcPwd.equals(OmHostsInfo.encryptPassword(string3))) {
                omHostsInfo.setBpcPassword(string3);
                bl2 = true;
            }
            if (bl2) {
                OmHostsInfo.saveBPCipList();
                modifyTime = System.currentTimeMillis();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setReady(byte by, String string, String string2, String string3, int n) throws PIHscServerException {
        boolean bl = false;
        boolean bl2 = false;
        System.err.println("OMHI setReady: num=" + by + "  ID=" + string + "  Host=" + string2 + "  ip=" + string3);
        if (by < 1 || by > 2 || string == null || string.length() != 16 || string2 == null || string3 == null) {
            throw new PIHscServerException("3075");
        }
        byte by2 = (byte)(by == 1 ? 2 : 1);
        String string4 = OmHostsInfo.buildBpcKey(by2, string);
        long l = OmHostsInfo.getLongValueOfIPstr(string3);
        Class clazz = thisClass;
        synchronized (clazz) {
            OmHostsInfo omHostsInfo;
            String string5 = OmHostsInfo.buildBpcKey(by, string);
            OmHostsInfo omHostsInfo2 = (OmHostsInfo)s_bpcList.get(string5);
            if (omHostsInfo2 == null) {
                omHostsInfo2 = (OmHostsInfo)s_bpcList.get(string4);
                if (omHostsInfo2 != null && l == omHostsInfo2.getBpcIPlong()) {
                    omHostsInfo2.setBpcNumber(by);
                    string5 = string4;
                    bl = true;
                } else {
                    omHostsInfo2 = (OmHostsInfo)s_bpcCache.get(string2);
                    if (omHostsInfo2 == null) {
                        System.err.println("OMHI setReady: not find, create a new one");
                        omHostsInfo2 = OmHostsInfo.addHostInfoObj(by, l, string, null, string2);
                    } else {
                        s_bpcCache.remove(string2);
                    }
                    bl2 = true;
                    bl = true;
                }
            }
            if (bl2 && omHostsInfo2.getBpcNumber() != by) {
                omHostsInfo2.setBpcNumber(by);
                bl = true;
            }
            if (bl2 && !omHostsInfo2.getBpcID(0).equals(string)) {
                omHostsInfo2.setBpcID(string);
                bl = true;
            }
            if (l > 0L && omHostsInfo2.getBpcIPlong() != l) {
                omHostsInfo2.setBpcIp(l);
                bl = true;
            }
            if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase(omHostsInfo2.m_host)) {
                omHostsInfo2.m_host = string2;
                bl = true;
            }
            if ((n & 1) == 0) {
                omHostsInfo2.m_bpcPwdBkup = omHostsInfo2.m_bpcPwd = OMHI_DEFAULT_PWD;
            }
            if (bl2 && (omHostsInfo = (OmHostsInfo)s_bpcList.get(string4)) != null && !omHostsInfo.m_bpcPwd.equals(omHostsInfo2.m_bpcPwd)) {
                omHostsInfo.setBpcPassword(OmHostsInfo.decryptPassword(omHostsInfo2.m_bpcPwd));
                bl = true;
            }
            if (bl) {
                s_bpcList.put(string5, omHostsInfo2);
                OmHostsInfo.saveBPCipList();
                modifyTime = System.currentTimeMillis();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBpcIpInfo(byte by, String string) throws PIHscServerException {
        Class clazz = thisClass;
        synchronized (clazz) {
            s_bpcList.remove(OmHostsInfo.buildBpcKey(by, string));
            OmHostsInfo.saveBPCipList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBpcIpInfo(String string, String string2) throws PIHscServerException {
        Class clazz = thisClass;
        synchronized (clazz) {
            s_bpcCache.remove(string);
            OmHostsInfo.saveBPCipList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector buildFilePackage() {
        Class clazz = thisClass;
        synchronized (clazz) {
            int n = s_bpcList.size();
            if (n <= 0) {
                return null;
            }
            int n2 = 16 + n * 60;
            byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF), 0, 1, 0, 0, 0, 16, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF), 0, 60, 0, 0};
            byte[] byArray2 = new byte[n2];
            for (int i = 0; i < 16; ++i) {
                byArray2[i] = byArray[i];
            }
            int n3 = 0;
            Enumeration enumeration = s_bpcList.elements();
            while (enumeration.hasMoreElements()) {
                int n4;
                byte[] byArray3 = ((OmHostsInfo)enumeration.nextElement()).getIpInfoBytes();
                byArray2[16 + n3 * 60] = byArray3[0] = (byte)(byArray3[0] - 1);
                for (n4 = 1; n4 < 16; ++n4) {
                    byArray2[16 + n3 * 60 + n4] = byArray3[n4];
                }
                for (n4 = 16; n4 < 23; ++n4) {
                    byArray2[16 + n3 * 60 + n4] = byArray3[n4 + 1];
                }
                byArray2[16 + n3 * 60 + 23] = 0;
                for (n4 = 24; n4 < 60; ++n4) {
                    byArray2[16 + n3 * 60 + n4] = byArray3[n4];
                }
                ++n3;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(new Long(modifyTime));
            vector.addElement(byArray2);
            return vector;
        }
    }

    public static void dumpIpList() {
        System.err.println("   OmHostsInfo list size = " + s_bpcList.size());
        Enumeration enumeration = s_bpcList.elements();
        while (enumeration.hasMoreElements()) {
            System.err.println((OmHostsInfo)enumeration.nextElement());
        }
        System.err.println("   OmHostsInfo cache size = " + s_bpcCache.size());
        enumeration = s_bpcCache.elements();
        while (enumeration.hasMoreElements()) {
            System.err.println((OmHostsInfo)enumeration.nextElement());
        }
    }

    public static void printByteArray(byte[] byArray, int n, int n2) {
        System.err.println("  === Byte Array. start=" + n + "  length=" + n2);
        System.err.print("   ");
        for (int i = n; i < n + n2; ++i) {
            System.err.print(byArray[i] + " ");
            if ((i + 1) % 16 != 0) continue;
            System.err.print("\n   ");
        }
        System.err.println();
    }

    protected OmHostsInfo(byte by, long l, String string, String string2, String string3) {
        this.m_bytes[0] = by;
        this.m_bytes[1] = 0;
        this.m_bytes[2] = 0;
        this.m_bytes[3] = 0;
        this.m_bpcPwdBkup = this.m_bpcPwd = OMHI_DEFAULT_PWD;
        if (l >= 0L) {
            this.setBpcIp(l);
        }
        if (string != null) {
            this.setBpcID(string);
        }
        if (string2 != null) {
            this.setBpcPassword(string2);
        }
        if (string3 != null && string3.length() > 0) {
            this.m_host = string3;
        }
    }

    protected OmHostsInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        for (int i = 0; i < 60; ++i) {
            this.m_bytes[i] = byArray[i];
        }
        try {
            this.m_bpcPwd = new String(byArray2, charSet);
            this.m_bpcPwdBkup = new String(byArray3, charSet);
            this.m_host = new String(byArray4, charSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_bpcPwd = new String(byArray2);
            this.m_bpcPwdBkup = new String(byArray3);
            this.m_host = new String(byArray4);
        }
    }

    protected OmHostsInfo(OmHostsInfo omHostsInfo) {
        for (int i = 0; i < 60; ++i) {
            this.m_bytes[i] = omHostsInfo.m_bytes[i];
        }
        this.m_bpcPwd = new String(omHostsInfo.m_bpcPwd);
        this.m_bpcPwdBkup = new String(omHostsInfo.m_bpcPwdBkup);
        this.m_host = new String(omHostsInfo.m_host);
    }

    void setBpcNumber(byte by) {
        this.m_bytes[0] = by;
    }

    void setBpcIp(long l) {
        long l2 = l;
        this.m_bytes[7] = (byte)(l2 & 0xFFL);
        this.m_bytes[6] = (byte)(l2 >> 8 & 0xFFL);
        this.m_bytes[5] = (byte)(l2 >> 16 & 0xFFL);
        this.m_bytes[4] = (byte)(l2 >> 24 & 0xFFL);
    }

    void setBpcIp(String string) throws PIHscServerException {
        long l = OmHostsInfo.getLongValueOfIPstr(string);
        this.setBpcIp(l);
    }

    void setBpcID(String string) {
        int n = string.length();
        if (n > 16) {
            n = 16;
        }
        for (int i = 0; i < n; ++i) {
            this.m_bytes[i + 8] = (byte)string.charAt(i);
        }
        for (int i = i + 8; i < 28; ++i) {
            this.m_bytes[i] = 0;
        }
    }

    byte[] getIpInfoBytes() {
        int n;
        byte[] byArray;
        byte[] byArray2 = new byte[60];
        try {
            byArray = OmHostsInfo.decryptPassword(this.m_bpcPwd).getBytes(charSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            byArray = OmHostsInfo.decryptPassword(this.m_bpcPwd).getBytes();
        }
        int n2 = byArray.length;
        for (n = 0; n < 28; ++n) {
            byArray2[n] = this.m_bytes[n];
        }
        for (n = 0; n < n2; ++n) {
            byArray2[n + 28] = byArray[n];
        }
        for (int i = n + 28; i < 60; ++i) {
            byArray2[i] = 0;
        }
        return byArray2;
    }

    protected void setBpcPassword(String string) {
        if (string == null || string.length() <= 0 || string.length() > 31) {
            return;
        }
        this.m_bpcPwdBkup = this.m_bpcPwd;
        this.m_bpcPwd = OmHostsInfo.encryptPassword(string);
    }

    public byte getBpcNumber() {
        return this.m_bytes[0];
    }

    public String getBpcHost() {
        return this.m_host;
    }

    public String getBpcID(int n) {
        switch (n) {
            case 0: {
                return new String(this.m_bytes, 8, 16);
            }
            case 1: {
                return new String(this.m_bytes, 8, 4);
            }
            case 2: {
                return new String(this.m_bytes, 13, 3);
            }
            case 3: {
                return new String(this.m_bytes, 18, 7);
            }
        }
        return null;
    }

    public String getBpcIPstr() {
        int[] nArray = new int[4];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            nArray[i] = this.m_bytes[i + 4];
            if (nArray[i] >= 0) continue;
            nArray[i] = nArray[i] + 256;
        }
        stringBuffer.append(nArray[0]).append(".").append(nArray[1]).append(".").append(nArray[2]).append(".").append(nArray[3]);
        return stringBuffer.toString();
    }

    public long getBpcIPlong() {
        long l = (long)(this.m_bytes[4] << 24) & 0xFF000000L | (long)(this.m_bytes[5] << 16) & 0xFF0000L | (long)(this.m_bytes[6] << 8) & 0xFF00L | (long)(this.m_bytes[7] & 0xFF);
        return l;
    }

    public boolean isSameBPC(byte by, String string) {
        return by == this.m_bytes[0] && this.getBpcID(0).equals(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_bytes[0]).append(" IP=").append(this.getBpcIPstr()).append(" ID=").append(this.getBpcID(0)).append(" HOST=").append(this.m_host);
        stringBuffer.append("  [ ").append(this.m_bpcPwd).append(" ").append(this.m_bpcPwdBkup).append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (!new File(OMHI_DBG).exists()) {
            return;
        }
        byte by = 1;
        String string = "100.100.0.001";
        String string2 = "100.100.0.002";
        String string3 = "100.100.0.003";
        int n = 1010100;
        int n2 = 9000000;
        String string4 = "F940-BPC*";
        String string5 = "pwdabcd";
        if (stringArray[0].equals("0")) {
            System.err.println("0-help, 1-create objects, 2-build package,\n3-dump, 4-setReady, 5-setPassword, 6-chkdhcp");
        } else if (stringArray[0].equals("101")) {
            try {
                long l = OmHostsInfo.getLongValueOfIPstr("9.53.182.20");
                OmHostsInfo.createBpcIpInfo(by, string, string4 + n, string5 + n);
                OmHostsInfo.createBpcIpInfo(by, string2, string4 + (n - 100), null);
                OmHostsInfo.createBpcIpInfo(by, string3, string4 + (n - 110), string5 + n);
                OmHostsInfo.createBpcIpInfo("localhost", string5 + (n - 10));
                OmHostsInfo.createBpcIpInfo("myhost", string5 + (n - 20));
                OmHostsInfo.createBpcIpInfo("bpcSideA", string5 + (n - 30));
                OmHostsInfo.createBpcIpInfo("bpcSideB", null);
                for (int i = 0; i < 6; ++i) {
                    by = (byte)(by == 1 ? 2 : 1);
                    ++n;
                    ++l;
                    ++n2;
                    if (i == 6) {
                        OmHostsInfo.createBpcIpInfo(by, l, string4 + n, null, null, true);
                    } else {
                        OmHostsInfo.createBpcIpInfo(by, l, string4 + n, string5 + n2, null, true);
                    }
                    if (n % 2 != 1) continue;
                    by = (byte)(by == 1 ? 2 : 1);
                    OmHostsInfo.createBpcIpInfo(by, ++l, string4 + n, string5 + ++n2, null, true);
                }
                OmHostsInfo.dumpIpList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray[0].equals("2")) {
            byte[] byArray = (byte[])OmHostsInfo.buildFilePackage().elementAt(1);
            System.out.println(" === dump the FilePackage. Bytes=" + byArray.length);
            OmHostsInfo.printByteArray(byArray, 0, byArray.length);
        } else if (stringArray[0].equals("3")) {
            OmHostsInfo.dumpIpList();
        } else if (stringArray[0].equals("4")) {
            try {
                System.out.println("  ---------- Query HOST Info ----------");
                System.out.println("A=" + OmHostsInfo.getBpcIpInfo((byte)1, "F940-BPC*1010103"));
                System.out.println("B=" + OmHostsInfo.getBpcIpInfo((byte)2, "F940-BPC*1010104"));
                System.out.println("D=" + OmHostsInfo.getBpcIpInfo((byte)-1, "9.53.182.21"));
                System.out.println("E=" + OmHostsInfo.getBpcIpInfo((byte)-1, "9.053.182.023"));
                System.out.println("F=" + OmHostsInfo.getBpcIpInfo((byte)-1, "123.156.89.1"));
                System.out.println("  ---------- setReady --------");
                System.out.println("G setReady(): " + OmHostsInfo.setReady((byte)2, "F940-BPC*1010103", "youhost", "222.222.222.222", 0));
                OmHostsInfo.dumpIpList();
                System.out.println("          ---------------");
                System.out.println("H setReady(): " + OmHostsInfo.setReady((byte)1, "F940-BPC*1010103", "myhost", "222.222.222.222", 1));
                OmHostsInfo.dumpIpList();
                System.out.println("          ---------------");
                System.out.println("I setReady(): " + OmHostsInfo.setReady((byte)2, "F940-BPC*2010109", "myhost", "123.124.125.126", 0));
                OmHostsInfo.dumpIpList();
                System.out.println("          ---------------");
                System.out.println("IX setReady(): " + OmHostsInfo.setReady((byte)1, "F940-BPC*1010101", "SingleBPC", "5.5.5.5", 0));
                OmHostsInfo.dumpIpList();
                System.out.println("  ---------- Query again ----------");
                System.out.println("J=" + OmHostsInfo.getBpcIpInfo((byte)1, "F940-BPC*1010105"));
                System.out.println("K=" + OmHostsInfo.getBpcIpInfo((byte)-1, "111.222.11.3"));
                System.out.println("L=" + OmHostsInfo.getBpcIpInfo((byte)-2, "localhost"));
                System.out.println("M=" + OmHostsInfo.getBpcIpInfo((byte)-2, "localhost.localdomain"));
                System.out.println("N=" + OmHostsInfo.getBpcIpInfo((byte)2, "F940-BPC*2010109"));
                System.out.println("O=" + OmHostsInfo.getBpcIpInfo((byte)1, "F940-BPC*1010106"));
                System.out.println("P=" + OmHostsInfo.getBpcIpInfo((byte)1, "F940-BPC*1010103"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray[0].equals("5")) {
            try {
                System.out.println(" --------- setPassword --------");
                OmHostsInfo.setPassword((byte)1, "F940-BPC*1010102", "oneBPC", "xyz98765", "1.1.9.9");
                OmHostsInfo.dumpIpList();
                System.out.println("          ---------------");
                OmHostsInfo.setPassword((byte)2, "BPCS-IDE*9999911", "bpcSideB", "sideB", "9.9.9.11");
                OmHostsInfo.dumpIpList();
                System.out.println("          ---------------");
                OmHostsInfo.setPassword((byte)1, "BPCS-IDE*9999910", "bpcSideA", "sideA", "9.9.9.10");
                OmHostsInfo.dumpIpList();
                System.out.println("          ---------------");
                OmHostsInfo.setPassword((byte)2, "F940-BPC*1010101", "bpcSideA", "pwrg00d", "5.5.5.5");
                OmHostsInfo.dumpIpList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray[0].equals("6")) {
            System.out.println("Check DHCPsvr status : " + OmHostsInfo.isDHCPsvrRunning());
        }
    }

    static {
        modifyTime = 0L;
        FileInputStream fileInputStream = null;
        if (OmHostsInfo.isDHCPsvrRunning()) {
            s_Enabled = 1;
        }
        try {
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(HMCCFG_FILE);
            properties.load(fileInputStream);
            fileInputStream.close();
            fileInputStream = null;
            String string = properties.getProperty(OMHI_PUSHIP);
            if (string != null) {
                if (string.equalsIgnoreCase("disable")) {
                    s_Enabled = 0;
                } else if (string.equalsIgnoreCase("enable")) {
                    s_Enabled = 1;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Throwable throwable2) {
                fileInputStream = null;
            }
            throwable.printStackTrace();
        }
        try {
            thisClass = Class.forName("com.ibm.hsc.objmgr.console.OmHostsInfo");
            s_crypt = HmcCryptor.getHmcCryptor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.err.println("OMHI: Get thisClass=" + thisClass + " " + s_Enabled);
        OmHostsInfo.loadBPCipList();
    }
}

